jQuery(document).ready(function(){

	var date = document.getElementById('birthdate');

	function checkValue(str, max) {
	  if (str.charAt(0) !== '0' || str == '00') {
	    var num = parseInt(str);
	    if (isNaN(num) || num <= 0 || num > max) num = 1;
	    str = num > parseInt(max.toString().charAt(0)) && num.toString().length == 1 ? '0' + num : num.toString();
	  };
	  return str;
	};

	if(jQuery('.subscription-form').length > 0){
		date.addEventListener('input', function(e) {
		  this.type = 'text';
		  var input = this.value;
		  if (/\D\/$/.test(input)) input = input.substr(0, input.length - 3);
		  var values = input.split('/').map(function(v) {
		    return v.replace(/\D/g, '')
		  });
		  if (values[0]) values[0] = checkValue(values[0], 12);
		  if (values[1]) values[1] = checkValue(values[1], 31);
		  var output = values.map(function(v, i) {
		    return v.length == 2 && i < 2 ? v + ' / ' : v;
		  });
		  this.value = output.join('').substr(0, 14);
		});

		date.addEventListener('blur', function(e) {
		  this.type = 'text';
		  var input = this.value;
		  var values = input.split('/').map(function(v, i) {
		    return v.replace(/\D/g, '')
		  });
		  var output = '';
		  
		  if (values.length == 3) {
		    var year = values[2].length !== 4 ? parseInt(values[2]) + 2000 : parseInt(values[2]);
		    var month = parseInt(values[0]) - 1;
		    var day = parseInt(values[1]);
		    var d = new Date(year, month, day);
		    if (!isNaN(d)) {
		      document.getElementById('result').innerText = d.toString();
		      var dates = [d.getMonth() + 1, d.getDate(), d.getFullYear()];
		      output = dates.map(function(v) {
		        v = v.toString();
		        return v.length == 1 ? '0' + v : v;
		      }).join(' / ');
		    };
		  };
		  this.value = output;
		});

		jQuery("#postcode").keyup(function() {
	        var maxChars = 4;
	        if (jQuery(this).val().length > maxChars) {
	            jQuery(this).val(jQuery(this).val().substr(0, maxChars));
	        }
	    });
	}
	
});